/*
 * Decompiled with CFR 0.152.
 */
package com.sothawo.mapjfx.offline;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class WriteCacheFileInputStream
extends FilterInputStream {
    private final OutputStream out;
    private Runnable notifyOnClose;

    protected WriteCacheFileInputStream(InputStream in, OutputStream out) {
        super(in);
        this.out = out;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int numBytes = super.read(b, off, len);
        if (null != this.out && numBytes > 0) {
            this.out.write(b, off, numBytes);
        }
        return numBytes;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (null != this.out) {
            this.out.flush();
            this.out.close();
        }
        if (null != this.notifyOnClose) {
            this.notifyOnClose.run();
        }
    }

    public void onInputStreamClose(Runnable r) {
        this.notifyOnClose = r;
    }
}

